<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package sparkling
 */

get_header(); ?>

	<section id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<div class="container my-search-result">

				<div class="container">
		          <div class="row">
		            <div class="breadcrumbs">
		              <?php if(function_exists('bcn_display'))
		              {
		                bcn_display();
		              }?>
		            </div>
		          </div>
		        </div>

				<h1 class="my-page-title">
					<span class="my-title">Search Result</span>
					<span class="my-deco"></span>
				</h1>

				<div class="my-search-box">
					<?php echo do_shortcode("[search_product]");?>
				</div>

				<?php if ( have_posts() ) : ?>

					<header class="page-header">
						<h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'sparkling' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
					</header><!-- .page-header -->

					<h1 class="my-page-title sub-title">
						<span class="my-title"><?php printf( esc_html__( 'Search Results for: %s', 'sparkling' ), '<span>' . get_search_query() . '</span>' ); ?></span>
						<span class="my-deco"></span>
					</h1>

					<?php /* Start the Loop */ ?>

					<?php while ( have_posts() ) : the_post(); ?>

						<?php get_template_part( 'content', 'search' ); ?>

					<?php endwhile; ?>

					<?php //sparkling_paging_nav(); ?>

					<div class="my-pagination"><?php wp_pagenavi(); ?></div>

				<?php else : ?>

					<?php get_template_part( 'content', 'none' ); ?>

				<?php endif; ?>

			</div>

		</main><!-- #main -->
	</section><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
