<?php
/**
 * @package sparkling
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="post-inner-content">
		<div class="container">
			<section class="custom-product-container custom-product-search">
				<div class="page-left">
					<h3>Product Information</h3>
					<?php echo do_shortcode ('[wpb_category_accordion taxonomy="product-category" orderby="id" order="ASC" show_count="no" hide_empty="no"]'); ?>
					<div style="margin-top: 10px;"><a href="http://www.threebond.co.jp/en/catalog/catalog.html" target="_blank"><img src="/wp-content/uploads/2017/02/bnr-web-catalog.jpg"></a></div>
					<div style="height: 50px; clear:both;"></div>
				</div>

				<div class="right-content">
					<h1 class="my-page-title">
						<span class="my-title">Product Information</span>
						<span class="my-deco"></span>
					</h1>


					<div class="my-search-box">
						<h4>Search Product</h4>
						<?php echo do_shortcode("[search_product]");?>
						To search for products, SDS or technical information, enter the product name in the box.
					</div>

					<div style="clear:both;"></div>

					<div class="home-redirect">
						<a href="#" class="btn btn-link btn-lg">Directions for Use of Products <i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
						<a href="#" class="btn btn-link btn-lg">Product Safety Guide <i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
					</div>

					<div style="clear:both;"></div>

					<div class="search-box-result">

						<h4 class="page-title">
							<?php printf( esc_html__( 'Search Results for: "%s"', 'sparkling' ), '<span>' . get_search_query() . '</span>' ); ?>
						</h4>

						<table>
							<tr>
								<th>Product Name</th>
								<th>Category</th>
								<th>Redirect</th>
							</tr>
							<?php while ( have_posts() ) : the_post(); ?>

							<tr>
								<td><?php the_title(); ?></td>
								<td>
								<?php 
									$myterms = get_the_terms( $post->ID, 'product-category' );
									if ( !empty( $myterms ) ){
									    // get the last term
									    $myterm = end( $myterms );
									    
									}else{
										$myterm = "Products";
									}
									echo $myterm->name;
								?>
								</td>
								<td>
									<a href="<?php the_permalink(); ?>" class="btn btn-default">View More</a>
								</td>

							</tr>
							<?php endwhile; ?>
						</table>
					</div>

					<div class="my-product-intro">
						<div class="my-box">
							<div class="left-col">
								<span class="my-txt">These are examples of products.<br>To inquire about other products, please click here.</span>
								<span class="left-border"></span>
							</div>
							<div class="right-col">
								<a class="btn btn-default"><i class="fa fa-chevron-right" aria-hidden="true"></i> Questions</a>
							</div>
						</div>
					</div>
				</div>

			</section>
		</div>
	</div>
</article><!-- #post-## -->
