<?php
/**
 * @package sparkling
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php //the_post_thumbnail( 'sparkling-featured', array( 'class' => 'single-featured' )); ?>
	<div class="post-inner-content">
		<div class="container">
			<section class="custom-product-container custom-category-list">
				<?php 
					$current_id = get_queried_object()->term_id;
					$prodcut_count= '';
					$product_list2 = '';

						$args = array(
							'post_type' => 'product',
							'orderby' => 'name',
							'paged' => get_query_var('paged'), 
							'tax_query' => array(
						      array(
						      'taxonomy' => 'product-category',
						      'field' => 'id',
						      'terms' => $current_id
						      )
					       	)
						);
				
					$query = new WP_Query( $args ); 
					if ( $query->have_posts() ) : while ( $query->have_posts() ) : $query->the_post();
						$prodcut_count++;
						$class= ($prodcut_count%3==0) ? 'row_last' :'';
						$product_list2.='<div class="mc_product '.$class.'">';
		        		$product_list2.='<div class="mc_product_wrapper">';
		        		$product_list2.='<a href="'.get_permalink().'?myid='.$current_id.'">';
		        		if ( has_post_thumbnail() ){
		        			$imageid = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'thumbnail' );
							$featimage = $imageid['0'];
		        			$product_list2.='<div class="sub_product_img"><img src="'.$featimage.'"/></div>';
		        		}else{
		        			$product_list2.='<div class="sub_product_img"><img src="'.get_template_directory_uri().'/images/no-image.png"/></div>';
		        		}
		        		
		        		$product_list2.='<div class="sub_product_info"><div class="sub_product_name">'. get_the_title().'</div>';

		        		$short_desc = types_render_field("short-description", array("output"=>"text"));
		        		if (!empty($short_desc)){
		        			$product_list2.='<div class="product-short-desc">('.$short_desc.')</div>';
		        		}
		        		
		        		$product_list2.='</div></a>';
		        		$product_list2.='</div>';
		        		$product_list2.='</div>';

					endwhile;
						//echo easy_wp_pagenavigation();
					else:
		        		$product_list2.='<h3 class="product-not-available">Sorry, product not found!</h3>';
					endif;
					//wp_reset_postdata();
				//endwhile; ?>

				<div class="page-left">
					<h3>Product Information</h3>
					<?php echo do_shortcode ('[wpb_category_accordion taxonomy="product-category" orderby="id" order="ASC" show_count="no" hide_empty="no"]'); ?>
					<div style="margin-top: 10px;"><a href="http://www.threebond.co.jp/en/catalog/catalog.html" target="_blank"><img src="/wp-content/uploads/2017/02/bnr-web-catalog.jpg"></a></div>
					<div style="height: 50px; clear:both;"></div>
				</div>

				<div class="right-content sub-cat-list">
					<h1 class="my-page-title">
						<span class="my-title">
							<?php 
								$myterm = get_term_by('id', $current_id, 'product-category');
								echo $myterm -> name;
							?>
						</span>
						<span class="my-deco"></span>
					</h1>

					<p><strong>Introducing ThreeBond's high performance, original technology products.</strong></p>

					<div class="mc_product_list">
						<?php echo $product_list2; ?>
						<div style="clear:both; width: 100%;"></div>
						<?php 
							wp_pagenavi( array( 'query' => $query ) );
							wp_reset_postdata();
						 ?>
					</div>

					<div class="home-redirect">
						<a href="#" class="btn btn-link btn-lg">Directions for Use of Products <i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
						<a href="#" class="btn btn-link btn-lg">Product Safety Guide <i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
					</div>

					<div class="my-product-intro">
						<div class="my-box">
							<div class="left-col">
								<span class="my-txt">These are examples of products.<br>To inquire about other products, please click here.</span>
								<span class="left-border"></span>
							</div>
							<div class="right-col">
								<a class="btn btn-default" href="<?php get_template_directory_uri(); ?>/questions"><i class="fa fa-chevron-right" aria-hidden="true"></i> Questions</a>
							</div>
						</div>
					</div>
				</div>

			</section>
		</div>

		<footer class="entry-meta">

	    	<?php if(has_tag()) : ?>
	      <!-- tags -->
	      <div class="tagcloud">

	          <?php
	              $tags = get_the_tags(get_the_ID());
	              foreach($tags as $tag){
	                  echo '<a href="'.get_tag_link($tag->term_id).'">'.$tag->name.'</a> ';
	              } ?>

	      </div>
	      <!-- end tags -->
	      <?php endif; ?>

		</footer><!-- .entry-meta -->
	</div>

	<?php if (get_the_author_meta('description')) :  ?>
		<div class="post-inner-content secondary-content-box">
      <!-- author bio -->
      <div class="author-bio content-box-inner">

        <!-- avatar -->
        <div class="avatar">
            <?php echo get_avatar(get_the_author_meta('ID') , '60'); ?>
        </div>
        <!-- end avatar -->

        <!-- user bio -->
        <div class="author-bio-content">

          <h4 class="author-name"><a href="<?php echo get_author_posts_url(get_the_author_meta( 'ID' )); ?>"><?php echo get_the_author_meta('display_name'); ?></a></h4>
          <p class="author-description">
              <?php echo get_the_author_meta('description'); ?>
          </p>

        </div><!-- end .author-bio-content -->

      </div><!-- end .author-bio  -->

		</div>
		<?php endif; ?>

</article><!-- #post-## -->
