<?php
/**
 * Navigation menu related functions
 * @package ninja
 */

/**
 * Primary header menu
 */
if ( ! function_exists( 'ninja_header_menu' ) ) :
function ninja_header_menu() {
  wp_nav_menu(array(
    'menu'              => 'primary',
    'theme_location'    => 'primary',
    'depth'             => 3,
    'container'         => 'nav',
    'container_class'   => 'collapse navbar-collapse navbar-ex1-collapse',
    'menu_class'        => 'nav navbar-nav',
    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
    'walker'            => new wp_bootstrap_navwalker()
  ));
}
endif;

/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 *
 * @param array $args Configuration arguments.
 * @return array
 */
function ninja_page_menu_args( $args ) {
  $args['show_home'] = true;
  return $args;
}
add_filter( 'wp_page_menu_args', 'ninja_page_menu_args' );

/**
 * Social Menu
 */
if ( ! function_exists( 'ninja_social_icons' ) ) :
function ninja_social_icons(){
  if ( has_nav_menu( 'social-menu' ) ) {
  	wp_nav_menu(
  		array(
  			'theme_location'  => 'social-menu',
  			'container'       => 'nav',
  			'container_id'    => 'menu-social',
  			'container_class' => 'social-icons',
  			'menu_id'         => 'menu-social-items',
  			'menu_class'      => 'social-menu',
  			'depth'           => 1,
  			'fallback_cb'     => '',
        'link_before'     => '<i class="social_icon fab"><span>',
        'link_after'      => '</span></i>'
  		)
	  );
  }
}
endif;

/**
 * Skype URI support for social media icons
 */
function ninja_allow_skype_protocol( $protocols ){
  $protocols[] = 'skype';
  return $protocols;
}
add_filter( 'kses_allowed_protocols' , 'ninja_allow_skype_protocol' );