/* jshint onevar: false */

(function($){
	/**
	 * For images lacking explicit dimensions and needing them, try to add them.
	 */
	var restore_dims = function() {
		$( 'img[data-recalc-dims]' ).each( function recalc() {
			var $this = $( this );
			if ( this.complete ) {

				// Support for lazy loading: if there is a lazy-src
				// attribute and it's value is not the same as the current src we
				// should wait until the image load event
				if ( $this.data( 'lazy-src' ) && $this.attr( 'src' ) !== $this.data( 'lazy-src' ) ) {
					$this.load( recalc );
					return;
				}

				var width = this.width,
					height = this.height;

				if ( width && width > 0 && height && height > 0 ) {
					$this.attr( {
						width: width,
						height: height
					} );

					reset_for_retina( this );
				}
			}
			else {
				$this.load( recalc );
			}
		} );
	},

	/**
	 * Modify image's markup so that it won't be reprocessed by this script.
	 */
	reset_for_retina = function( img ) {
		$( img ).removeAttr( 'data-recalc-dims' ).removeAttr( 'scale' );
	};

	/**
	 * Check both when page loads, and when post-load is triggered.
	 */
	$( document ).ready( restore_dims );

	if ( 'on' in $.fn ) {
		$( document.body ).on( 'post-load', restore_dims );
	} else {
		$( document ).delegate( 'body', 'post-load', restore_dims );
	}
})(jQuery);
