<?php
    defined( 'ABSPATH' ) || exit;
?>

<?php
    
    // $value = 'upcoming';
    // if ($value == 'upcoming'){
    //     $compare = '>=';
    // }else{
    //     $compare = '<=';
    // }
    $args = array(
        'post_type' => 'post',
        'orderby' => 'date',
        'order'   => 'Desc',
        'posts_per_page' => '10',
        'paged' => get_query_var('paged'),
        'meta_key'    => 'wpcf-event-end-date', 
        'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field'    => 'slug',
                'terms'    => 'news-event',
            ),
        ),
        // 'meta_query' => array(
        //     array(
        //         'key'     => 'wpcf-event-end-date',
        //         'value'   => strtotime("now"),
        //         'compare' => $compare,
        //         'type' => 'numeric'
        //     ),
        // ),
    );
    $query = new WP_Query( $args ); 
    if ( $query->have_posts() ) :
        
?>

    <div class="event-wrapper">

        <ul class="cat-list cat-listing ntype-list events-list ">
        <?php 
            while ( $query->have_posts() ) : $query->the_post();

                if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
                    $thumb_id = get_post_thumbnail_id();
                    $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size', true);
                    $thumb_url = $thumb_url_array[0];
                } 

                $start = types_render_field("event-start-date", array("output"=>"normal"));
                $end = types_render_field("event-end-date", array("output"=>"normal"));
                $venue = types_render_field("venue", array("output"=>"raw"));
                $booth = types_render_field("booth", array("output"=>"raw"));
                $link = types_render_field("external-link", array("output"=>"raw"));
                $html = '';
                if (!empty($start)){
                    $html .= $start;
                    if (!empty($end)){
                        $html .= ' - '.$end;
                    }
                }

        ?>
            <li>
                <div class="block inner-nbox nbox-shadow">
                    <div class="img-wrapper"><img src="<?php echo $thumb_url; ?>"/></div>
                    <div class="post-content-wrapper">
                        <div class="contain-wrapper">
                            <h5 class=""><?php echo get_the_title(); ?></h5>
                            <div class="inner-contain-wrapper">
                                <div class="npost-venue"><?php echo $venue; ?></div>
                                <div class="npost-booth">Booth: <?php echo $booth; ?></div>
                                <div class="npost-date"><?php echo $html; ?></div>
                                <a href="<?php echo $link; ?>" class="btn btn-default btn-lg" target="_blank"><?php echo __("Read More","ninja"); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </li>

            <?php endwhile;?>

        </ul>
        <?php wp_pagenavi( array( 'query' => $query ) ); ?>
        
    </div>

    <?php else: ?>
        <p class='coming-soon-content'>Stay tuned for more exciting events.</p>
    <?php endif; ?>
